#!/bin/sh
mount -t ubifs ubi0:cachefs /cache -o bulk_read
test -d "/cache" || exit 1
rm -rf /cache/fota /cache/recovery
mkdir -p /cache/recovery
mkdir -p /cache/fota
rm -rf /cache/image
rm -rf /data/modem_backup_flag

mv /data/sbfota/ipth_package.bin /cache/fota/ipth_package.bin
test -f "/cache/fota/ipth_package.bin" || exit 1

echo "IP_START_UPDATE" > /cache/fota/ipth_config_dfs.txt

ubiattach -m `cat /proc/mtd | grep \"recoveryfs\" | sed -r 's/.*d(.*):.*/\1/'` -d 3 /dev/ubi_ctrl
sleep 1
if [ ! -c "/dev/ubi3_0" ];then
    echo "ubiattach error"
    exit 1
fi

mkdir -p /tmp/mount_recovery
mount -t ubifs /dev/ubi3_0 /tmp/mount_recovery -o bulk_read
if [ ! -L "/tmp/mount_recovery/sbin/usb/boot_hsusb_composition" ];then
    echo "/tmp/mount_recovery/ not found"
    exit 1
fi

if [ ! -x "/sbin/usb/compositions/recovery_9607" ];then
    echo "recovery_9607 not found"
    exit 1
fi
ln -sf /sbin/usb/compositions/recovery_9607 /tmp/mount_recovery/sbin/usb/boot_hsusb_composition
sync